/*
 * Decompiled with CFR 0.152.
 */
package oracle.ops.verification.framework.command;

import oracle.ops.mgmt.trace.Trace;
import oracle.ops.verification.framework.command.VerificationCommand;
import oracle.ops.verification.framework.engine.Result;
import oracle.ops.verification.framework.util.VerificationUtil;

public class GetBugSymbolCommand
extends VerificationCommand {
    private static String m_arg1 = "-getbugsym";

    public GetBugSymbolCommand(String nodeName, String home) {
        super(nodeName, null, null);
        String[] args = new String[]{m_arg1, home};
        super.setArgs(args);
    }

    @Override
    public boolean execute() {
        Trace.out((String)("GetBugSymbolCommand::Inside execute() " + Thread.currentThread().getName()));
        boolean bResult = super.execute();
        Result result = this.getResult();
        if (!bResult) {
            String trcTxt = "super.execute() failed for GetBugSymbolCommand...";
            Trace.out((String)trcTxt);
            result.addTraceInfo(trcTxt);
            Trace.out((String)"getting bug symbols failed");
            result.addErrorInfo("getting bug symbols failed");
            result.setStatus(2);
            return false;
        }
        Trace.out((String)"super.execute() was succcessful for GetBugSymbolCommand...");
        String[] resultString = this.getCommandResult().getResultString();
        String bugSymbolFmtdStr = VerificationUtil.strArr2List(resultString, System.getProperty("line.separator"));
        if (!VerificationUtil.fetchExecResult(bugSymbolFmtdStr)) {
            String trcTxt = "Exectask result shows failure for -getbugsym...";
            Trace.out((String)trcTxt);
            result.addTraceInfo(trcTxt);
            Trace.out((String)"getting bug symbols failed");
            result.addErrorInfo("getting bug symbols failed");
            result.setStatus(2);
            return false;
        }
        String[] bugSymbols = VerificationUtil.fetchVerificationValue(bugSymbolFmtdStr).split(System.getProperty("line.separator"));
        Trace.out((String)"after calling fetchVerificationValue() ");
        Trace.out((String)("The version of exectask at node '" + this.getNodeName() + "' is '" + bugSymbols + "'"));
        result.addTraceInfo("The version of exectask at node '" + this.getNodeName() + "' is '" + bugSymbols + "'");
        result.addResultInfo(bugSymbols);
        result.setStatus(1);
        return true;
    }
}

